/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.usbdm.connections.usbdm;

import com.freescale.cdt.debug.cw.core.ui.publicintf.ISettingsListener;
import com.freescale.cdt.debug.cw.core.ui.settings.PrefException;
import net.sourceforge.usbdm.connections.usbdm.CFVxDeviceData;
import net.sourceforge.usbdm.connections.usbdm.UsbdmConnectionPanel;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class UsbdmCFVxConnectionPanel
extends UsbdmConnectionPanel {
    private Button btnAutomaticallyReconnect;
    private Button btnUsePstSignals;
    private Combo comboConnectionSpeed;
    private Label lblTargetId;

    public UsbdmCFVxConnectionPanel(Composite parent, int style) {
        super(parent, style);
        this.init();
        this.defaultBdmOptions = new UsbdmConnectionPanel.DefaultBdmOptions(this);
    }

    public UsbdmCFVxConnectionPanel(ISettingsListener listener, Composite parent, int swtstyle, String protocolPlugin, String connectionTypeId) {
        super(listener, parent, swtstyle, protocolPlugin, connectionTypeId);
        this.init();
    }

    private void init() {
        this.deviceNameId = "com.freescale.cdt.debug.cw.CW_SHADOWED_PREF.CF Debugger.processor";
        this.gdiDllName = "usbdm-cfvx-gdi";
        this.gdiDebugDllName = "usbdm-cfvx-gdi-debug";
        this.attributeKey = "net.sourceforge.usbdm.connections.usbdm.cfvx.";
    }

    @Override
    public void create() {
        this.createContents((Composite)this);
        this.addSettingsChangedListeners();
    }

    @Override
    protected void restoreDefaultSettings() {
        if (this.defaultBdmOptions == null) {
            this.defaultBdmOptions = new UsbdmConnectionPanel.DefaultBdmOptions(this);
        }
        super.restoreDefaultSettings();
        try {
            this.btnAutomaticallyReconnect.setSelection(this.defaultBdmOptions.autoReconnect != 0);
            this.comboConnectionSpeed.select(this.comboConnectionSpeed.indexOf("1.5MHz"));
            this.btnUsePstSignals.setSelection(this.defaultBdmOptions.usePSTSignals != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadSettings(ILaunchConfiguration iLaunchConfiguration) {
        this.launchConfiguration = iLaunchConfiguration;
        super.loadSettings(iLaunchConfiguration);
        try {
            this.btnAutomaticallyReconnect.setSelection(this.getIntAttribute(iLaunchConfiguration, this.attrib("automaticReconnect"), this.defaultBdmOptions.autoReconnect) != 0);
            this.btnUsePstSignals.setSelection(this.getIntAttribute(iLaunchConfiguration, this.attrib("usePstSignals"), this.defaultBdmOptions.cycleVddOnReset) != 0);
            this.btnUseDebugBuild.setSelection(this.getIntAttribute(iLaunchConfiguration, this.attrib("useDebugBuild"), 0) != 0);
            this.comboConnectionSpeed.select(this.comboConnectionSpeed.indexOf(iLaunchConfiguration.getAttribute("connectionSpeed", "1.5MHz")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lblTargetId.setText(this.GetGdiLibrary());
    }

    @Override
    public void saveSettings(ILaunchConfigurationWorkingCopy paramILaunchConfigurationWorkingCopy) throws PrefException {
        super.saveSettings(paramILaunchConfigurationWorkingCopy);
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("automaticReconnect"), this.btnAutomaticallyReconnect.getSelection() ? "1" : "0");
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("connectionSpeed"), this.comboConnectionSpeed.getText());
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("usePSTSignals"), this.btnUsePstSignals.getSelection() ? "1" : "0");
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("useDebugBuild"), this.btnUseDebugBuild.getSelection() ? "1" : "0");
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("clockTrimNVAddress"), null);
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("clockTrimFrequency"), null);
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("useResetSignal"), null);
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("trimTargetClock"), null);
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("useAltBDMClock"), null);
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("targetClockFrequency"), null);
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("guessSpeedIfNoSYNC"), null);
    }

    @Override
    protected void addSettingsChangedListeners() {
        super.addSettingsChangedListeners();
        if (this.fListener != null) {
            this.btnAutomaticallyReconnect.addSelectionListener(this.fListener.getSelectionListener());
            this.btnUsePstSignals.addSelectionListener(this.fListener.getSelectionListener());
            this.comboConnectionSpeed.addSelectionListener(this.fListener.getSelectionListener());
            this.btnUseDebugBuild.addSelectionListener(this.fListener.getSelectionListener());
        }
    }

    @Override
    protected void createContents(Composite comp) {
        super.createContents(comp);
        Group grpConnectionControl = new Group((Composite)this, 0);
        RowLayout rl_grpConnectionControl = new RowLayout(512);
        rl_grpConnectionControl.marginHeight = 3;
        grpConnectionControl.setLayout((Layout)rl_grpConnectionControl);
        grpConnectionControl.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 2));
        grpConnectionControl.setText("Connection Control");
        this.btnAutomaticallyReconnect = new Button((Composite)grpConnectionControl, 32);
        this.btnAutomaticallyReconnect.setToolTipText("Automatically re-sync with the target whenever target state is polled.");
        this.btnAutomaticallyReconnect.setText("Automatically re-connect");
        this.btnUsePstSignals = new Button((Composite)grpConnectionControl, 32);
        this.btnUsePstSignals.setToolTipText("Use PST signal to determine execution state of target.");
        this.btnUsePstSignals.setText("Use PST signals");
        Composite composite_3 = new Composite((Composite)grpConnectionControl, 0);
        composite_3.setLayout((Layout)new RowLayout(256));
        Label lblConnectionSpeed = new Label(composite_3, 0);
        lblConnectionSpeed.setToolTipText("Connection speed to use for JTAG communications.\r\nSpeed < Target Clock frequency/5");
        lblConnectionSpeed.setText("Connection\r\nSpeed");
        this.comboConnectionSpeed = new Combo(composite_3, 8);
        this.comboConnectionSpeed.setItems(CFVxDeviceData.getConnectionSpeeds());
        this.comboConnectionSpeed.setToolTipText("");
        this.comboConnectionSpeed.setLayoutData((Object)new RowData(-1, 29));
        this.comboConnectionSpeed.select(4);
        Composite composite_2 = new Composite((Composite)this, 0);
        composite_2.setLayout((Layout)new FillLayout(512));
        GridData gd_composite_2 = new GridData(4, 128, false, false, 1, 1);
        gd_composite_2.horizontalIndent = 5;
        gd_composite_2.verticalIndent = 5;
        composite_2.setLayoutData((Object)gd_composite_2);
        this.toolkit.adapt(composite_2);
        this.toolkit.paintBordersFor(composite_2);
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        Group grpDebuggingOptions = new Group((Composite)this, 0);
        grpDebuggingOptions.setText("Debugging Options");
        grpDebuggingOptions.setLayout((Layout)new RowLayout(256));
        grpDebuggingOptions.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.toolkit.adapt((Composite)grpDebuggingOptions);
        this.toolkit.paintBordersFor((Composite)grpDebuggingOptions);
        this.btnUseDebugBuild = new Button((Composite)grpDebuggingOptions, 32);
        this.btnUseDebugBuild.setToolTipText("Used for debugging USBDM drivers - don't enable");
        this.toolkit.adapt((Control)this.btnUseDebugBuild, true, true);
        this.btnUseDebugBuild.setText("Use debug build");
        this.btnUseDebugBuild.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsbdmCFVxConnectionPanel.this.lblTargetId.setText(UsbdmCFVxConnectionPanel.this.GetGdiLibrary());
            }
        });
        this.lblTargetId = new Label(composite_2, 131072);
        this.toolkit.adapt((Control)this.lblTargetId, true, true);
        this.lblTargetId.setText("Target ID");
        super.appendContents((Composite)this);
    }
}

